﻿$User = $env:UserName
$Folder = "C:\Users\$($User)"

Get-ChildItem -Path "$folder\appdata\Roaming\Microsoft\Signatures" | Remove-Item -include "MailSig.htm","MailSig.txt","MailSig.rtf"
Copy-Item "\\dwp.local\NETLOGON\Outlook\*" -include "MailSig.htm","MailSig.txt","MailSig.rtf" "$folder\appdata\Roaming\Microsoft\Signatures"

$FileName = "MailSig"
$FileExtension = "htm","rtf","txt"
$Path = "$env:APPDATA\Microsoft\Signatures"

$Data = Get-ADUser $User -Properties City,Company,Description,Mobile,HomePage,Mail,OfficePhone,PostalCode,StreetAddress,Fax

foreach ($Extens in $FileExtension)
    {
        (Get-Content "$Path\$FileName.$Extens") | Foreach-Object {
                $_`
                -replace "@NAME", $Data.Name `
                -replace "@DESCRIPTION", $Data.Description `
                -replace "@MOBILE", $Data.Mobile `
                -replace "@COMPANY", $Data.Company `
                -replace "@STREETADDRESS", $Data.StreetAddress `
                -replace "@POSTALCODE", $Data.PostalCode `
                -replace "@CITY", $Data.City `
                -replace "@EMAIL", $Data.Mail `
                -replace "@WEBSITE", $Data.Homepage `
                -replace "@OFFICEPHONE", $Data.OfficePhone `
                -replace "@FAX", $Data.FAX `
            } | Set-Content "$env:APPDATA\Microsoft\Signatures\$FileName.$Extens"
    }